<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 

?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Notifications</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Notifications</li>
        </ol>




        <div class="row my-4">
            <div class="col-12 add-category-box">
                <h1 class="category-heading">Send Notification</h1>
                <div class="categort-add-container">
                    <form method="post" action="code.php" enctype="multipart/form-data"
                        class="d-flex align-items-start flex-wrap">
                        <div class="mb-3 mx-2">
                            <label for="image" class="form-label">Image</label>
                            <input required name="image" type="file" class="form-control" id="image">

                        </div>
                        <div class="mb-3 mx-2">
                            <label for="title" class="form-label">Title</label>
                            <input required type="text" placeholder="Title" class="form-control" name="title" id="title">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" placeholder="Description" id="description" name="description" rows="1" cols="50" ></textarea>
                        </div>
                        <button class="add-category-btn mt-4" name="send_notification" type="submit">Send To All</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="row mb-4">

            <div class="user-table">
                    <table id="example" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>                              
                                <th>SR No.</th>
                                <th>Avatar</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Notification</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
            
            $sql = "SELECT * FROM `users`";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):
                       

                       
                        ?>



                            <tr id="box<?= $row['id']; ?>">
                                <td>
                                    <?= $i; ?>
                                </td>
                                <td><img style="width: 50px; height: 50px;" src="<?= $row['avatar']; ?>" alt="icon">

                                <td>
                                    <?= $row['name']; ?>
                                </td>
                                

                                <td>
                                <?= $row['email']; ?>
                                </td>
                                <td>
                                <button
                                        
                                        class="edit-user edit-btn send-notif-ind" value="<?= $row['uId']; ?>"><i class="fa-solid fa-bell"></i></button>
                                        
                                </td>
                            </tr>


                            <?php

                        $i++;
                    endforeach;








                else:
                    echo "No Category Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                        </tbody>
                    </table>


            </div>
        </div>




        



    </div>





  <!-- Modal -->
  <div class="modal fade" id="sendNotificationInd" tabindex="-1" aria-labelledby="sendNotificationIndLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="sendNotificationIndLabel">Send Notiication</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <form action="code.php" method="post" enctype="multipart/form-data">
      <div class="modal-body">
          <div class="mb-3 mx-2">
              <label for="image" class="form-label">Image</label>
              <input required name="image" type="file" class="form-control" id="image">
              <input type="hidden" name="uId" class="user-uid" id="uId">
            
        </div>
        <div class="mb-3 mx-2">
            <label for="title" class="form-label">Title</label>
            <input required type="text" placeholder="Title" class="form-control" name="title" id="title">
        </div>
        <div class="mb-3 mx-2">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" placeholder="Description" id="description" name="description" rows="1" cols="50" ></textarea>
        </div>
            <button class="add-category-btn mt-3" name="send_notification_to_user" type="submit">Send Notification</button>
      </div>
    </form>
      <div class="modal-footer d-flex justify-content-start">
    </div>
    </div>
  </div>
</div>



</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>

<script>
    $(document).ready(function () {
        $('.send-notif-ind').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.user-uid').val(id);
            $('#sendNotificationInd').modal('show')
        });
    });

</script>


<script>
        $(document).ready(function () {
            var table = $('#example').DataTable({
                language: {
                    searchPlaceholder: "Search Users"
                },
                columnDefs: [
                    {
                        targets: 0,
                        checkboxes: {
                            selectRow: true
                        }
                    }
                ],
                select: {
                    style: 'multi'
                },
                order: [[1, 'asc']]

            });

        });



</script>




<?php

include("includes/footer.php");


?>